<?php $__env->startSection('title', 'Login - ' . $book->title); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen flex items-center justify-center px-4 py-12 bg-gradient-to-br from-indigo-50 to-blue-50">
    <div class="max-w-4xl w-full">
        <div class="bg-white rounded-2xl shadow-2xl overflow-hidden">
            <div class="grid grid-cols-1 md:grid-cols-2">

                <!-- Left Side - Book Preview -->
                <div class="relative bg-gradient-to-br from-indigo-600 to-purple-600 p-8 flex flex-col justify-center items-center text-white">
                    <div class="absolute inset-0 bg-black opacity-10"></div>

                    <div class="relative z-10 text-center">
                        <!-- Book Cover -->
                        <div class="mb-6 transform hover:scale-105 transition duration-300">
                            <img
                                src="<?php echo e($book->cover_url); ?>"
                                alt="<?php echo e($book->title); ?>"
                                class="w-48 h-64 object-cover rounded-lg shadow-2xl mx-auto border-4 border-white"
                                onerror="this.src='https://via.placeholder.com/400x600/6366f1/ffffff?text=No+Cover'"
                            >
                        </div>

                        <!-- Book Info -->
                        <h2 class="text-2xl font-bold mb-2"><?php echo e($book->title); ?></h2>

                        <?php if($book->school_name): ?>
                            <p class="text-indigo-100 mb-2">
                                <i class="fas fa-school mr-2"></i><?php echo e($book->school_name); ?>

                            </p>
                        <?php endif; ?>

                        <p class="text-indigo-200 text-sm">
                            <i class="fas fa-calendar mr-2"></i>Tahun <?php echo e($book->year); ?>

                        </p>

                        <?php if($book->description): ?>
                            <div class="mt-4 px-4">
                                <p class="text-sm text-indigo-100 line-clamp-3">
                                    <?php echo e($book->description); ?>

                                </p>
                            </div>
                        <?php endif; ?>

                        <!-- Stats -->
                        <div class="flex justify-center gap-6 mt-6 text-sm">
                            <div>
                                <i class="fas fa-eye mb-1"></i>
                                <p class="font-semibold"><?php echo e($book->view_count); ?></p>
                                <p class="text-xs text-indigo-200">Views</p>
                            </div>
                            <div>
                                <i class="fas fa-download mb-1"></i>
                                <p class="font-semibold"><?php echo e($book->download_count); ?></p>
                                <p class="text-xs text-indigo-200">Downloads</p>
                            </div>
                            <div>
                                <i class="fas fa-file-alt mb-1"></i>
                                <p class="font-semibold"><?php echo e($book->pages->count()); ?></p>
                                <p class="text-xs text-indigo-200">Halaman</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Right Side - Login Form -->
                <div class="p-8 md:p-12">
                    <div class="mb-8">
                        <h3 class="text-3xl font-bold text-gray-900 mb-2">
                            <i class="fas fa-lock text-indigo-600 mr-2"></i>Akses Buku
                        </h3>
                        <p class="text-gray-600">
                            Masukkan username dan password untuk membuka buku ini
                        </p>
                    </div>

                    <!-- Login Form -->
                    <form method="POST" action="<?php echo e(route('book.login.submit', $book->id)); ?>" class="space-y-6">
                        <?php echo csrf_field(); ?>

                        <!-- Username -->
                        <div>
                            <label for="username" class="block text-sm font-medium text-gray-700 mb-2">
                                <i class="fas fa-user mr-2 text-indigo-600"></i>Username
                            </label>
                            <input
                                type="text"
                                id="username"
                                name="username"
                                value="<?php echo e(old('username')); ?>"
                                required
                                autofocus
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                placeholder="Masukkan username"
                            >
                            <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-2 text-sm text-red-600">
                                    <i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?>

                                </p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Password -->
                        <div>
                            <label for="password" class="block text-sm font-medium text-gray-700 mb-2">
                                <i class="fas fa-key mr-2 text-indigo-600"></i>Password
                            </label>
                            <div class="relative" x-data="{ showPassword: false }">
                                <input
                                    :type="showPassword ? 'text' : 'password'"
                                    id="password"
                                    name="password"
                                    required
                                    class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    placeholder="Masukkan password"
                                >
                                <button
                                    type="button"
                                    @click="showPassword = !showPassword"
                                    class="absolute right-3 top-3 text-gray-500 hover:text-gray-700"
                                >
                                    <i class="fas" :class="showPassword ? 'fa-eye-slash' : 'fa-eye'"></i>
                                </button>
                            </div>
                            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-2 text-sm text-red-600">
                                    <i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?>

                                </p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Info Box -->
                        <div class="bg-blue-50 border-l-4 border-blue-500 p-4 rounded">
                            <div class="flex items-start">
                                <i class="fas fa-info-circle text-blue-500 mt-0.5 mr-3"></i>
                                <div class="text-sm text-blue-800">
                                    <p class="font-medium mb-1">Informasi Login</p>
                                    <p>Username dan password buku ini diberikan oleh sekolah atau pengelola buku tahunan.</p>
                                </div>
                            </div>
                        </div>

                        <!-- Submit Button -->
                        <button
                            type="submit"
                            class="w-full bg-indigo-600 text-white py-3 px-6 rounded-lg font-semibold hover:bg-indigo-700 focus:ring-4 focus:ring-indigo-300 transition transform hover:scale-105 active:scale-95"
                        >
                            <i class="fas fa-sign-in-alt mr-2"></i>Buka Buku
                        </button>

                        <!-- Back Link -->
                        <div class="text-center">
                            <a href="<?php echo e(route('home')); ?>" class="text-sm text-gray-600 hover:text-indigo-600 transition">
                                <i class="fas fa-arrow-left mr-2"></i>Kembali ke Katalog
                            </a>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
    .line-clamp-3 {
        display: -webkit-box;
        -webkit-line-clamp: 3;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\Nostraa\resources\views/book/login.blade.php ENDPATH**/ ?>